/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import tiled.util.TiledConfiguration;

public class FloatablePanel
extends JPanel {
    private final JLabel titleLabel;
    private JDialog frame;
    private final JComponent child;
    private final Frame parent;
    private final Preferences prefs;
    private int dividerSize;

    public FloatablePanel(Frame parent, JComponent child, String title, String preferencesId) {
        this.child = child;
        this.parent = parent;
        this.titleLabel = new JLabel(title);
        this.prefs = TiledConfiguration.node("dock/" + preferencesId);
        JButton floatButton = new JButton("Float");
        floatButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloatablePanel.this.setFloating(true);
            }
        });
        HeaderPanel topPanel = new HeaderPanel(new BorderLayout());
        topPanel.add((Component)this.titleLabel, "West");
        topPanel.add((Component)floatButton, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)child, "Center");
        this.dividerSize = 0;
        this.frame = null;
    }

    private void setFloating(boolean floating) {
        JSplitPane splitPane = (JSplitPane)this.getParent();
        if (this.frame != null && !floating) {
            this.prefs.putInt("width", this.frame.getWidth());
            this.prefs.putInt("height", this.frame.getHeight());
            this.prefs.putInt("x", this.frame.getX());
            this.prefs.putInt("y", this.frame.getY());
            this.frame.getContentPane().remove(this.child);
            this.frame.dispose();
            this.frame = null;
            this.child.setBorder(null);
            this.add((Component)this.child, "Center");
            this.setVisible(true);
            int dividerLocation = this.prefs.getInt("dividerLocation", 0);
            splitPane.setDividerSize(this.dividerSize);
            splitPane.setDividerLocation(dividerLocation);
        } else if (this.frame == null && floating) {
            this.dividerSize = splitPane.getDividerSize();
            this.prefs.putInt("dividerLocation", splitPane.getDividerLocation());
            this.setVisible(false);
            this.remove(this.child);
            splitPane.setDividerSize(0);
            this.child.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.frame = new JDialog(this.parent, this.titleLabel.getText());
            this.frame.getContentPane().add(this.child);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    FloatablePanel.this.setFloating(false);
                }
            });
            int lastFrameWidth = this.prefs.getInt("width", 0);
            int lastFrameHeight = this.prefs.getInt("height", 0);
            int lastFrameX = this.prefs.getInt("x", 0);
            int lastFrameY = this.prefs.getInt("y", 0);
            if (lastFrameWidth > 0) {
                this.frame.setSize(lastFrameWidth, lastFrameHeight);
                this.frame.setLocation(lastFrameX, lastFrameY);
            } else {
                this.frame.pack();
                this.frame.setLocationRelativeTo(this.parent);
            }
            this.frame.setVisible(true);
        }
    }

    public void restore() {
        int dividerLocation = this.prefs.getInt("dividerLocation", 0);
        boolean floating = this.prefs.getBoolean("floating", false);
        if (floating) {
            this.setFloating(true);
        } else if (dividerLocation > 0) {
            JSplitPane splitPane = (JSplitPane)this.getParent();
            splitPane.setDividerLocation(dividerLocation);
        }
    }

    public void save() {
        this.prefs.putBoolean("floating", this.frame != null);
        if (this.frame != null) {
            this.prefs.putInt("width", this.frame.getWidth());
            this.prefs.putInt("height", this.frame.getHeight());
            this.prefs.putInt("x", this.frame.getX());
            this.prefs.putInt("y", this.frame.getY());
        } else {
            JSplitPane splitPane = (JSplitPane)this.getParent();
            this.prefs.putInt("dividerLocation", splitPane.getDividerLocation());
        }
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
        if (this.frame != null) {
            this.frame.setTitle(title);
        }
    }

    private class HeaderPanel
    extends JPanel {
        public HeaderPanel(BorderLayout borderLayout) {
            super(borderLayout);
            this.setBorder(BorderFactory.createEmptyBorder(1, 4, 2, 1));
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color backgroundColor = new Color(200, 200, 240);
            g.setColor(backgroundColor);
            ((Graphics2D)g).fill(g.getClip());
            g.setColor(backgroundColor.darker());
            g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

